@extends('layouts.app')

@section('title', 'Purchase History')

@section('content')
<div class="container">
    <div class="purchase-history">
        <!-- Page Header -->
        <div class="page-header">
            <div class="header-content">
                <h1>Purchase History</h1>
                <p>Track all your store purchases and transaction details</p>
            </div>
            <div class="header-actions">
                <a href="{{ route('store.index') }}" class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5zM3.102 4l1.313 7h8.17l1.313-7H3.102zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
                    </svg>
                    Continue Shopping
                </a>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492zM5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0z"/>
                        <path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52l-.094-.319z"/>
                    </svg>
                </div>
                <div class="stat-content">
                    <h3>{{ $stats['total_purchases'] }}</h3>
                    <p>Total Purchases</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon money">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M8 10a2 2 0 1 0 0-4 2 2 0 0 0 0 4z"/>
                        <path d="M0 4a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1V4zm3 0a2 2 0 0 1-2 2v4a2 2 0 0 1 2 2h10a2 2 0 0 1 2-2V6a2 2 0 0 1-2-2H3z"/>
                    </svg>
                </div>
                <div class="stat-content">
                    <h3>£{{ number_format($stats['total_spent'], 2) }}</h3>
                    <p>Total Spent</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon pending">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71V3.5z"/>
                        <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0z"/>
                    </svg>
                </div>
                <div class="stat-content">
                    <h3>{{ $stats['pending_transactions'] }}</h3>
                    <p>Pending Orders</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon favorite">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                        <path d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053c-.523 1.023-.641 2.5.314 4.385.92 1.815 2.834 3.989 6.286 6.357 3.452-2.368 5.365-4.542 6.286-6.357.955-1.886.838-3.362.314-4.385C13.486.878 10.4.28 8.717 2.01L8 2.748zM8 15C-7.333 4.868 3.279-3.04 7.824 1.143c.06.055.119.112.176.171a3.12 3.12 0 0 1 .176-.17C12.72-3.042 23.333 4.867 8 15z"/>
                    </svg>
                </div>
                <div class="stat-content">
                    <h3>{{ $stats['most_purchased_type']->type ?? 'None' }}</h3>
                    <p>Favorite Category</p>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="filters-section">
            <form method="GET" class="filters-form">
                <div class="filter-group">
                    <label for="search">Search</label>
                    <div class="search-input">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                        </svg>
                        <input type="text" id="search" name="search" placeholder="Search by package or transaction ID..." value="{{ $search }}">
                    </div>
                </div>

                <div class="filter-group">
                    <label for="status">Status</label>
                    <select name="status" id="status">
                        <option value="all" {{ $status === 'all' ? 'selected' : '' }}>All Statuses</option>
                        <option value="completed" {{ $status === 'completed' ? 'selected' : '' }}>Completed</option>
                        <option value="pending" {{ $status === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="cancelled" {{ $status === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        <option value="failed" {{ $status === 'failed' ? 'selected' : '' }}>Failed</option>
                    </select>
                </div>

                <div class="filter-group">
                    <label for="package_type">Package Type</label>
                    <select name="package_type" id="package_type">
                        <option value="all" {{ $package_type === 'all' ? 'selected' : '' }}>All Types</option>
                        <option value="vip" {{ $package_type === 'vip' ? 'selected' : '' }}>VIP</option>
                        <option value="money" {{ $package_type === 'money' ? 'selected' : '' }}>Money</option>
                        <option value="job" {{ $package_type === 'job' ? 'selected' : '' }}>Jobs</option>
                        <option value="vehicle" {{ $package_type === 'vehicle' ? 'selected' : '' }}>Vehicles</option>
                        <option value="weapon" {{ $package_type === 'weapon' ? 'selected' : '' }}>Weapons</option>
                    </select>
                </div>

                <div class="filter-group">
                    <label for="date_range">Date Range</label>
                    <select name="date_range" id="date_range">
                        <option value="all" {{ $date_range === 'all' ? 'selected' : '' }}>All Time</option>
                        <option value="7_days" {{ $date_range === '7_days' ? 'selected' : '' }}>Last 7 Days</option>
                        <option value="30_days" {{ $date_range === '30_days' ? 'selected' : '' }}>Last 30 Days</option>
                        <option value="90_days" {{ $date_range === '90_days' ? 'selected' : '' }}>Last 90 Days</option>
                        <option value="1_year" {{ $date_range === '1_year' ? 'selected' : '' }}>Last Year</option>
                    </select>
                </div>

                <div class="filter-actions">
                    <button type="submit" class="btn btn-filter">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                        </svg>
                        Apply Filters
                    </button>
                    <a href="{{ route('store.purchase-history') }}" class="btn btn-clear">Clear</a>
                </div>
            </form>
        </div>

        <!-- Transactions List -->
        <div class="transactions-section">
            @if($transactions->count() > 0)
                <div class="transactions-list">
                    @foreach($transactions as $transaction)
                        <div class="transaction-card" data-status="{{ $transaction->status }}">
                            <div class="transaction-header">
                                <div class="package-info">
                                    <div class="package-icon">
                                        @switch($transaction->package->type)
                                            @case('vip')
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                                    <path d="M5.354 4.646a.5.5 0 1 0-.708.708L7.293 8l-2.647 2.646a.5.5 0 0 0 .708.708L8 8.707l2.646 2.647a.5.5 0 0 0 .708-.708L8.707 8l2.647-2.646a.5.5 0 0 0-.708-.708L8 7.293 5.354 4.646z"/>
                                                </svg>
                                                @break
                                            @case('money')
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                                    <path d="M8 10a2 2 0 1 0 0-4 2 2 0 0 0 0 4z"/>
                                                    <path d="M0 4a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1V4zm3 0a2 2 0 0 1-2 2v4a2 2 0 0 1 2 2h10a2 2 0 0 1 2-2V6a2 2 0 0 1-2-2H3z"/>
                                                </svg>
                                                @break
                                            @default
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                                    <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492z"/>
                                                </svg>
                                        @endswitch
                                    </div>
                                    <div class="package-details">
                                        <h4>{{ $transaction->package->name }}</h4>
                                        <p>{{ Str::limit($transaction->package->description, 60) }}</p>
                                    </div>
                                </div>
                                <div class="transaction-status">
                                    <span class="status-badge {{ $transaction->status_badge_class }}">
                                        {{ ucfirst($transaction->status) }}
                                    </span>
                                </div>
                            </div>

                            <div class="transaction-details">
                                <div class="detail-item">
                                    <span class="label">Amount</span>
                                    <span class="value amount">£{{ number_format($transaction->amount, 2) }}</span>
                                </div>
                                
                                @if($transaction->server)
                                <div class="detail-item">
                                    <span class="label">Server</span>
                                    <span class="value">{{ $transaction->server->name }}</span>
                                </div>
                                @endif

                                <div class="detail-item">
                                    <span class="label">Payment Method</span>
                                    <span class="value">{{ $transaction->payment_method_display }}</span>
                                </div>

                                <div class="detail-item">
                                    <span class="label">Date</span>
                                    <span class="value">{{ $transaction->created_at->format('M d, Y H:i') }}</span>
                                </div>

                                @if($transaction->transaction_id)
                                <div class="detail-item">
                                    <span class="label">Transaction ID</span>
                                    <span class="value transaction-id">{{ Str::limit($transaction->transaction_id, 20) }}</span>
                                </div>
                                @endif
                            </div>

                            <div class="transaction-actions">
                                <a href="{{ route('store.purchase-detail', $transaction->id) }}" class="btn btn-view">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
                                        <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
                                    </svg>
                                    View Details
                                </a>
                                
                                @if($transaction->status === 'completed')
                                <button class="btn btn-download" onclick="downloadReceipt('{{ $transaction->id }}')">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/>
                                        <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/>
                                    </svg>
                                    Receipt
                                </button>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Pagination -->
                <div class="pagination-wrapper">
                    {{ $transactions->links() }}
                </div>
            @else
                <div class="empty-state">
                    <div class="empty-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5z"/>
                        </svg>
                    </div>
                    <h3>No purchases found</h3>
                    <p>You haven't made any purchases yet or no transactions match your current filters.</p>
                    <a href="{{ route('store.index') }}" class="btn btn-primary">Start Shopping</a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function downloadReceipt(transactionId) {
        // Create a download link for receipt
        window.open(`/store/purchase/${transactionId}/receipt`, '_blank');
    }

    // Auto-submit form on filter changes (optional)
    document.addEventListener('DOMContentLoaded', function() {
        const filters = ['status', 'package_type', 'date_range'];
        
        filters.forEach(filterId => {
            const element = document.getElementById(filterId);
            if (element) {
                element.addEventListener('change', function() {
                    // Optional: Auto-submit on change
                    // this.form.submit();
                });
            }
        });
    });
</script>
@endpush